/************************************************************************
* \file: trace_dlt_utility.c
*
* \version: $Id: trace_dlt_utility.c,v 1.1 2012/02/24 14:25:53 bkebianyor Exp $
*
* This file implements the Trace back-end for DLT utility functions
*
* \component: Gen2 Trace
*
* \author Mikhail Durnev mikhail_durnev@mentor.com
* \copyright: (c) 2012 ADIT
*
***********************************************************************/

#include "trace_base.h"

EXPORT U8 *TRACE_bin2hex(U8 bin, U8 *hex)
{
    U8 hb = bin >> 4;
    if (hb > 9)
    {
        hb = hb - 10 + 'a';
    }
    else
    {
        hb += '0';
    }
    hex[0] = hb;

    hb = bin & 0xF;
    if (hb > 9)
    {
        hb = hb - 10 + 'a';
    }
    else
    {
        hb += '0';
    }
    hex[1] = hb;

    hex[2] = ' ';
    hex[3] = 0;

    return hex;
}

EXPORT S32 TRACE_hex2bin(U8 *hex)
{
    U8 result = 0;

    if (hex[0] < '0' || hex[0] > 'f' ||
        (hex[0] > '9' && hex[0] < 'a') ||
        hex[1] < '0' || hex[1] > 'f' ||
        (hex[1] > '9' && hex[1] < 'a') ||
        (hex[2] != ' ' && hex[2] != 0))
    {
        return -1; /* not a number */
    }

    if (hex[0] > '9')
    {
        result += (hex[0] - 'a' + 10) << 4;
    }
    else
    {
        result += (hex[0] - '0') << 4;
    }

    if (hex[1] > '9')
    {
        result += (hex[1] - 'a' + 10);
    }
    else
    {
        result += (hex[1] - '0');
    }

    return (S32)result;
}

